﻿using System.Net;
using System.Net.Mail;
using System.Text;

namespace SendMail {
   /// <summary>Stellt die Methode <see cref="MailSender.Send(string, string, string, SendMailConfig)"/>
   /// zum Versenden von E-Mail bereit.
   /// </summary>
   public class MailSender {
      /// <summary>Versendet eine E-Mail.</summary>
      /// <param name="recipient">E-Mail-Adresse des Empfängers.</param>
      /// <param name="subject">Betreff</param>
      /// <param name="text">Text (HTML!)</param>
      /// <param name="sendmailConfig">Verbindungsdaten zum Mail-Server.</param>
      /// <returns>null bei Erfolg, ansonsten eine Exception, die den Fehler bescheeibt.</returns>
      public static Exception? Send(string recipient, string subject, string text, SendMailConfig sendmailConfig) {

         NetworkCredential credential = new(sendmailConfig.mailAddress, sendmailConfig.password);

         SmtpClient smtpClient = new(sendmailConfig.mailHostName) {
            // set smtp-client with basicAuthentication
            UseDefaultCredentials = false,
            Credentials = credential,
            EnableSsl = true
         };

         // add from,to mailaddresses
         MailAddress from = new(sendmailConfig.mailAddress, sendmailConfig.displayName);
         MailAddress to = new(recipient, null);
         MailMessage mail = new(from, to) {
            // set subject and encoding
            Subject = subject,
            SubjectEncoding = Encoding.UTF8,

            // set body-message and encoding
            Body = text,
            BodyEncoding = System.Text.Encoding.UTF8,
            // text or html
            IsBodyHtml = true
         };

         try {
            smtpClient.Send(mail);
            return null;
         }
         catch (Exception ex) {
            return ex;
         }

      }
   }
}
