﻿
namespace SendMail {
   /// <summary>Verwaltet die Verbindungsdaten für den Mail-Server.</summary>
   public class SendMailConfig {
      /// <summary>Dateiname der Adressliste.</summary>
      public readonly string addressListFilename = "";
      /// <summary>Dateiname der Fehlerliste.</summary>
      public readonly string errorFilename ="";
      /// <summary>Eine Zeichenfolge, die den Namen oder die IP-Adresse des Hostcomputers enthält,
      /// der für SMTP-Transaktionen verwendet wird.</summary>
      public readonly string mailHostName = "";
      /// <summary>Mail-Adresse des Absenders.</summary>
      public readonly string mailAddress = "";
      /// <summary>Passwort für die Verbindung zum SMTP-Server.</summary>
      public readonly string password = "";
      /// <summary>Eine Zeichenfolge, die den mit der Adresse verbundenen Anzeigenamen enthält.</summary>
      public readonly string displayName = "";
      /// <summary>Test-Mail-Adresse, an die Test-Mails gesendet werden können.</summary>
      public readonly string testMailAddress = "";
      /// <summary>Verzögerung in Millisekunden zwischen dem Senden von zwei Mails.</summary>
      public readonly int delay = 1000;

      /// <summary>Initialisiert eine neue Instanz der SmptClientData-Klasse</summary>
      internal SendMailConfig() { }

      /// <summary>Initialisiert eine neue Instanz der SmptClientData-Klasse</summary>
      private SendMailConfig(string addressListFilename, string errorFilename, string mailHostName, string mailAddress, string password, string displayName, string testMailAddress, string strDelay ) {
         this.addressListFilename = addressListFilename;
         this.errorFilename = errorFilename;
         this.mailHostName = mailHostName;
         this.mailAddress = mailAddress;
         this.password = password;
         this.displayName = displayName;
         this.testMailAddress = testMailAddress;
         Int32.TryParse(strDelay, out delay);
      }

      /// <summary>Liest die Konfigurationsdaten aus einer Datei ein.</summary>
      /// <param name="fileName">Pfad und Name der Datei, aus der die Konfigurationsdaten gelesen werden sollen.</param>
      public static SendMailConfig FromFile(string fileName) {
         string[] allData = File.ReadAllText(fileName).Split("\r\n");
         SendMailConfig smc = new(allData[0], allData[1], allData[2], allData[3],
                                  allData[4], allData[5], allData[6], allData[7]);
         return smc;
      }
   }
}
