#include <Adafruit_NeoPixel.h>
#include <UrsEsp.h>
#include "AppVersion.h"

constexpr uint8_t LED_PIN = 8;     // BUILTIN_LED liefert nicht den passenden Wert
constexpr uint8_t NUM_LEDS = 1;    // Anzahl WS2812
constexpr uint8_t BRIGHTNESS = 64; // Max. Helligkeit, 1..255

Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUM_LEDS, LED_PIN, NEO_GRB + NEO_KHZ800);

void setup() {
   Serial.begin(115200);
   delay(1000); // Zeit zum Setup des Serial-Terminal
   Serial.printf("\n%s Version %s by %s\n", APP_NAME, APP_VERSION, APP_AUTHOR);
   Serial.println(APP_WEBSITE);
   Serial.println("Dieses Programm benutzt die Adafruit NeoPixel Bibliothek.");

   auto resetReason = UrsCPU::UrsESP.getResetReason(0);
   Serial.printf("\nCPU0 reset reason: %i (%s) %s\n", resetReason, UrsCPU::UrsESP.getResetReasonName(resetReason).c_str(), UrsCPU::UrsESP.getResetReasonDescription(resetReason).c_str());

   // Wenn nicht Power-On-Reset dann stoppen.
   if (resetReason != 1) { // Ansonsten erfolgt dauernd ein neuer Reset
      Serial.println("Programm angehalten");
      while (1);
   }

   pixels.begin();
}

void loop() {
   pixels.setPixelColor(0, pixels.Color(random(BRIGHTNESS), random(BRIGHTNESS), random(BRIGHTNESS)));
   pixels.show(); // Farbwerte bertragen.
   delay(500);
}
