#include <UrsEsp.h>
#include <esp32-hal-rmt.h>
#include "AppVersion.h"

constexpr uint8_t LED_PIN = 8;     // BUILTIN_LED liefert nicht den passenden Wert
constexpr uint8_t NUM_LEDS = 1;    // Anzahl WS2812
constexpr uint8_t BRIGHTNESS = 64; // Max. Helligkeit, 1..255
constexpr uint8_t NUMBEROFBITS = NUM_LEDS * 24; // Anzahl Bits, die bertragen werden mssen


void setup() {
   Serial.begin(115200);
   delay(1000); // Zeit zum Setup des Serial-Terminal
   Serial.printf("\n%s Version %s by %s\n", APP_NAME, APP_VERSION, APP_AUTHOR);
   Serial.println(APP_WEBSITE);

   auto resetReason = UrsCPU::UrsESP.getResetReason(0);
   Serial.printf("CPU0 reset reason: %i (%s) %s\n", resetReason, UrsCPU::UrsESP.getResetReasonName(resetReason).c_str(), UrsCPU::UrsESP.getResetReasonDescription(resetReason).c_str());

   // Wenn nicht Power-On-Reset dann stoppen.
   if (resetReason != 1) { // Ansonsten erfolgt dauernd ein neuer Reset
      Serial.println("Programm angehalten");
      while (1);
   }

   if (!rmtInit(LED_PIN, RMT_TX_MODE, RMT_MEM_NUM_BLOCKS_1, 10'000'000)) {
      Serial.println("Initialisierung des Senders fehlgeschlagen\nPogramm angehalten\n");
      while (1) delay(10);
   }
   Serial.println("RMT-Taktzeit auf 100ns festgelegt");
}
void loop() {
   xmitColor(random(BRIGHTNESS), random(BRIGHTNESS), random(BRIGHTNESS));
   delay(500);
}

// bertrgt eine RGB-Kombination an die WS2812
void xmitColor(uint8_t R, uint8_t G, uint8_t B) {
   rmt_data_t led_data[NUMBEROFBITS]; // 24 Bit fr eine WS2812
   int color[] = { G, R, B };// Green Red Blue values
   int i = 0;

   for (int colIndex = 0; colIndex < 3; colIndex++) {
      for (int bit = 0; bit < 8; bit++) {
         if (color[colIndex] & (1 << (7 - bit)))  // 0 oder 1?
            led_data[i] = { 8, 1, 4, 0 };
         else
            led_data[i] = { 4, 1, 8, 0 };
         i++;
      }
   }

   // Send the data and wait until it is done
   rmtWrite(LED_PIN, led_data, NUMBEROFBITS, RMT_WAIT_FOR_EVER);
}