package de.ullisroboterseite.ursai2sensorutil;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

import android.util.*;

import com.google.appinventor.components.annotations.*;
import com.google.appinventor.components.annotations.androidmanifest.*;
import com.google.appinventor.components.common.*;
import com.google.appinventor.components.runtime.*;
import com.google.appinventor.components.runtime.util.*;

@DesignerComponent(version = 1, //
        versionName = UrsAI2SensorUtil.VersionName, //
        dateBuilt = UrsAI2SensorUtil.dateBuilt, //
        description = "AI2 extension block for sensor support.", //
        category = com.google.appinventor.components.common.ComponentCategory.EXTENSION, //
        nonVisible = true, //
        helpUrl = "http://UllisRoboterSeite.de/android-AI2-Sensorutil.html", //
        iconName = "aiwebres/avg.png")
@SimpleObject(external = true)

public class UrsAverager extends AndroidNonvisibleComponent {
    static final String LOG_TAG = UrsAI2SensorUtil.LOG_TAG;

    // Queue to hold the data to be averaged
    final LinkedList<Float> dataCache = new LinkedList<Float>();

    int cacheSize = 5;

    public UrsAverager(ComponentContainer container) {
        super(container.$form());
    }

    @DesignerProperty(editorType = PropertyTypeConstants.PROPERTY_TYPE_NON_NEGATIVE_INTEGER, defaultValue = "5")
    @SimpleProperty(category = PropertyCategory.BEHAVIOR, description = "Specifies the number of values to aggregate.")
    public void CacheSize(int value) {
        this.cacheSize = value;
    }

    @SimpleProperty(category = PropertyCategory.BEHAVIOR, description = "Specifies the number of values to aggregate.")
    public int CacheSize() {
        return cacheSize;
    }

    @SimpleProperty(category = PropertyCategory.BEHAVIOR, description = "Gets the number of stored values.")
    public int Count() {
        return dataCache.size();
    }

    @SimpleProperty(category = PropertyCategory.BEHAVIOR, description = "Calcutes the average of the stored values.")
    public float Average() {
        float average = 0;
        for (float value : dataCache) {
            average += value;
        }
        average /= dataCache.size();

        return average;
    }

    @SimpleProperty(category = PropertyCategory.BEHAVIOR, description = "Calcutes the weighted average of the stored values.")
    public float WeightedAverage() {
        float average = 0;
        int divider = 0;

        for (int i = 0; i < dataCache.size(); i++) {
            average += dataCache.get(i) * i;
            divider += i;
        }
        average /= divider;

        return average;
    }

    @SimpleFunction(description = "Add a new value to the data cache.")
    public void Add(float value) {
        if (dataCache.size() >= cacheSize) {
            dataCache.remove();
        }
        dataCache.add((float) value);
    }
}