
#include <UrsWiFi.h>

#include "AppVersion.h"
#include "M28BYJ_48.h"
#include "UdpHandler.h"

UdpHandler udpHandler(2222, 2222);



M28BYJ_48 motor(12, 14, 27, 26, 11, MotorTypes::Strong);

void setup() {
   Serial.begin(115200);
   delay(1000);
   Serial.println(APP_NAME);

   UrsWiFi.connectStation("ssid", "password", "M28BYJ_48");
   motor.begin();

   udpHandler.setCommandCallback(processCommand);
   udpHandler.begin();
}

void loop() {
   udpHandler.handleUdp();
}

// Commands:
// R<speed> - Run clockwise at speed (steps per second) 
// L<speed> - Run counter-clockwise at speed (steps per second)
// r - Step clockwise one step
// l - Step counter-clockwise one step
// S - Stop
// C- Set gear clearance (in steps)
// O- Deactivate the motor (can be used to save power when the motor is not needed)


void processCommand(const char command, const int data1, const int data2) {
   switch (command) {
   case 'R':
      if (!motor.isInitialized()) { motor.begin(); }
      motor.run(Direction::CW, data1, data2);
      break;
   case 'L':
      if (!motor.isInitialized()) { motor.begin(); }
      motor.run(Direction::CCW, data1, data2);
      break;
   case 'r':
      if (!motor.isInitialized()) { motor.begin(); }
      motor.stepCW();
      break;
   case 'l':
      if (!motor.isInitialized()) { motor.begin(); }
      motor.stepCCW();
      break;
   case 'S':
      if (motor.isInitialized())
         motor.stop();
      break;
   case 'C':
         motor.setGearClearance(data1);
      break;
   case 'O':
     if (motor.isInitialized()) {
         motor.end();
      }
     break;
   default:
      break;
   }
}