#include "UdpHandler.h"
#include <string>

void UdpHandler::begin() {
   udp.begin(localPort);
}

// Packet format: <c><n>;<data1>;<data2>
// e.g., R5;1234;4567
void UdpHandler::handleUdp() {
   // check for incoming packets
   udp.parsePacket();
   if (udp.available()) {
      // read the packet into packetBuffer
      int len = udp.read(packetBuffer, 255);
      if (len > 0) {
         packetBuffer[len] = 0; // Null-terminate the string
      }
      Serial.print("Packet: ");
      Serial.print(packetBuffer);
      Serial.print(" from: ");
      Serial.println(udp.remoteIP().toString());

      // Echo back the received packet
      udp.beginPacket(udp.remoteIP(), remotePort);
      udp.write((uint8_t*)&packetBuffer[0], len);
      udp.endPacket();

      // Check for duplicate message
      if (strcmp(packetBuffer, lastmessage) == 0) {
         Serial.println("Duplicate message, ignoring.");
         return;
      }
      strcpy(lastmessage, packetBuffer);

      // Parse the command
      char* pch;
      pch = strtok(packetBuffer, ";");
      char command = pch[0];
      pch = strtok(NULL, ";");
      int number1 = std::stoi(pch);
      int number2 = 0;

      pch = strtok(NULL, ";");
      if (pch != NULL) {
         number2 = std::stoi(pch);
      }

      // Call the command processing callback
      Serial.printf("Command: %c, Number1: %d, Number2: %d\n", command, number1, number2);
      processCommand(command, number1, number2);
   }
}